﻿
CREATE PROCEDURE [App].[NVCC_usp_GetNextOfKin]
	@sid int   --PatientSid

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jon Duckart
--Object/SP Name        : [NVCC_usp_GetNextOfKin]
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 06-07-2016
--
--Purpose               : To retrieve a single patient NOK record for the NVCC app by SID.
--==================================================================================
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

   SELECT  SPatientAddressSID as NextOfKindId
   , PatientSID
   , Sta3n as Station
   , AddressType
   , NameOfContact
   , StreetAddress1
   , StreetAddress2
   , City
   , State
   , Zip
   , Phone
   , PhoneWork
   FROM  CDWWork.SPatient.SPatientAddress
   WHERE PatientSID= @sid and OrdinalNumber=2;  --OrdinalNumber=2, Next Of Kin
END;

